DROP PACKAGE ADR.IAM_UTIL_PKG;

CREATE OR REPLACE PACKAGE ADR.IAM_UTIL_PKG AUTHID CURRENT_USER
AS

  TYPE varchar2_table IS TABLE OF VARCHAR2(32767) INDEX BY BINARY_INTEGER;

  PROCEDURE USERS_IAM_INSERT_SP(
    p_USERNAME        IN USERS.USERNAME%TYPE,
    p_LAST_NAME        IN USERS.LAST_NAME%TYPE,
    p_FIRST_NAME        IN USERS.FIRST_NAME%TYPE,
    p_MIDDLE_NAME        IN USERS.MIDDLE_NAME%TYPE,
    p_STD_INSTITUTION_ID    IN STD_INSTITUTION.ID%TYPE,
    p_JOB_TITLE        IN USERS.JOB_TITLE%TYPE,
    p_PASSWORD        IN USERS.PASSWORD%TYPE,
    p_ACCOUNT_EXPIRE_DATE    IN USERS.ACCOUNT_EXPIRE_DATE%TYPE,
    p_PASSWORD_EXPIRE_DATE    IN USERS.PASSWORD_EXPIRE_DATE%TYPE,
    p_AGREEMENT_SIGNATURE_CODE IN USERS.AGREEMENT_SIGNATURE_CODE%TYPE,
    p_PASSWORD_CHANGE_DATE    IN USERS.PASSWORD_CHANGE_DATE%TYPE,
    p_PASSWORD_CREATE_DATE    IN USERS.PASSWORD_CREATE_DATE%TYPE,
    p_INACTIVE_FLAG        IN USERS.INACTIVE_FLAG%TYPE,
    p_NUMBER_OF_LOGIN_ATTEMPTS IN USERS.NUMBER_OF_LOGIN_ATTEMPTS%TYPE,
    p_SIGNATURE_VERIFIED_IND   IN USERS.SIGNATURE_VERIFIED_IND%TYPE,
    p_ROLES            IN VARCHAR2);

  PROCEDURE USERS_IAM_UPDATE_SP (
    p_USERNAME        IN USERS.USERNAME%TYPE,
    p_LAST_NAME        IN USERS.LAST_NAME%TYPE,
    p_FIRST_NAME        IN USERS.FIRST_NAME%TYPE,
    p_MIDDLE_NAME        IN USERS.MIDDLE_NAME%TYPE,
    p_STD_INSTITUTION_ID    IN STD_INSTITUTION.ID%TYPE,
    p_JOB_TITLE        IN USERS.JOB_TITLE%TYPE,
    p_PASSWORD        IN USERS.PASSWORD%TYPE,
    p_ACCOUNT_EXPIRE_DATE    IN USERS.ACCOUNT_EXPIRE_DATE%TYPE,
    p_PASSWORD_EXPIRE_DATE    IN USERS.PASSWORD_EXPIRE_DATE%TYPE,
    p_AGREEMENT_SIGNATURE_CODE IN USERS.AGREEMENT_SIGNATURE_CODE%TYPE,
    p_PASSWORD_CHANGE_DATE    IN USERS.PASSWORD_CHANGE_DATE%TYPE,
    p_PASSWORD_CREATE_DATE    IN USERS.PASSWORD_CREATE_DATE%TYPE,
    p_INACTIVE_FLAG        IN USERS.INACTIVE_FLAG%TYPE,
    p_NUMBER_OF_LOGIN_ATTEMPTS IN USERS.NUMBER_OF_LOGIN_ATTEMPTS%TYPE,
    p_SIGNATURE_VERIFIED_IND   IN USERS.SIGNATURE_VERIFIED_IND%TYPE,
    p_ROLES            IN VARCHAR2);

  PROCEDURE USERS_IAM_DELETE_SP (
    p_USERNAME    IN     USERS.USERNAME%TYPE);

  PROCEDURE delimstring_to_table
    ( p_delimstring IN VARCHAR2
    , p_table OUT varchar2_table
    , p_nfields OUT INTEGER
    , p_delim IN VARCHAR2 DEFAULT ','
    );

  PROCEDURE table_to_delimstring
    ( p_table IN varchar2_table
    , p_delimstring OUT VARCHAR2
    , p_delim IN VARCHAR2 DEFAULT ','
    );

END IAM_UTIL_PKG;
/


CREATE OR REPLACE PUBLIC SYNONYM IAM_UTIL_PKG FOR ADR.IAM_UTIL_PKG;


GRANT EXECUTE ON ADR.IAM_UTIL_PKG TO IAMUSR;
DROP PACKAGE ADR.HL7_ARCHIVE_PKG;

CREATE OR REPLACE PACKAGE ADR.Hl7_Archive_Pkg -- AUTHID CURRENT_USER
AS
-- Declare externally callable procedures

  FUNCTION Hl7_Archive_Control
    (PN_status_code
      IN     NUMBER)
    RETURN VARCHAR2;

  FUNCTION Hl7_Delete_Control
    (PN_status_code
      IN     NUMBER)
    RETURN VARCHAR2;

  PROCEDURE Hl7_Process_Archives
    (PB_run_standalone
       IN     BOOLEAN DEFAULT FALSE,
     PB_allow_rpt_inst
       IN     BOOLEAN DEFAULT FALSE
    );

  PROCEDURE Hl7_Process_Deletes
    (PB_run_standalone
       IN     BOOLEAN DEFAULT FALSE,
     PB_allow_rpt_inst
       IN     BOOLEAN DEFAULT FALSE
    );

END Hl7_Archive_Pkg;
/


GRANT EXECUTE ON ADR.HL7_ARCHIVE_PKG TO EEUSR;
DROP PACKAGE ADR.ADR_UTIL;

CREATE OR REPLACE PACKAGE ADR.adr_util AUTHID CURRENT_USER
AS
  PROCEDURE ADR_PIN_SEQ;
  PROCEDURE ADR_UNPIN_SEQ;
  PROCEDURE ADR_PIN_TRIGGERS;
  PROCEDURE ADR_UNPIN_TRIGGERS;
END adr_util;
/


CREATE OR REPLACE PUBLIC SYNONYM ADR_UTIL FOR ADR.ADR_UTIL;


GRANT EXECUTE ON ADR.ADR_UTIL TO AACDBA;
DROP PACKAGE ADR.MEC_PERIOD_PKG;

CREATE OR REPLACE PACKAGE ADR.MEC_PERIOD_PKG
AS
   /******************************************************************************
      NAME:       MEC_PERIOD_NEXT_GEN
      PURPOSE: Daily updateMEC_PERIOD_NEXT_GEN for new changes

      REVISIONS:
      Ver        Date        Author           Description
      ---------  ----------  ---------------  ------------------------------------
      1.0        Feb/04/2016      DNS      1. Created this package.
   ******************************************************************************/
   g_pkg_name                     CONSTANT VARCHAR2 (50) := 'MEC_PERIOD_PKG';
   g_param_name_for_lower_bound   CONSTANT VARCHAR2 (60) := 'MEC_PERIOD_LOWER_BOUND';
   g_final_rec_cnt                         INTEGER := 0;
   g_job_name                              VARCHAR2 (60);
   g_current_lower_bound                   INTEGER;

   -- This is only a Public procedure that is available for execution and rest of the procedures are all private.
   PROCEDURE KICK_OFF_MEC_PERIOD;
END MEC_PERIOD_PKG;
/


CREATE OR REPLACE PUBLIC SYNONYM MEC_PERIOD_PKG FOR ADR.MEC_PERIOD_PKG;
DROP PACKAGE ADR.SF_TIMER;

CREATE OR REPLACE PACKAGE ADR.sf_timer
IS
   /* Specification of Set/Get for "factor" */
   PROCEDURE set_factor (factor_in IN NUMBER);

   FUNCTION factor
      RETURN NUMBER;

   /* Capture current value in DBMS_UTILITY.GET_TIME */
   PROCEDURE start_timer (context_in IN VARCHAR2 := NULL);

   /* Return amount of time elapsed since call to capture */
   FUNCTION elapsed_time
      RETURN NUMBER;

   /* Construct message showing time elapsed since call to capture */
   FUNCTION elapsed_message (
      prefix_in          IN   VARCHAR2 := NULL
    , adjust_in          IN   NUMBER := 0
    , reset_in           IN   BOOLEAN := TRUE
    , reset_context_in   IN   VARCHAR2 := NULL
   )
      RETURN VARCHAR2;

   /* Display message of elapsed time */
   PROCEDURE show_elapsed_time (
      prefix_in   IN   VARCHAR2 := NULL
    , adjust_in   IN   NUMBER := 0
    , reset_in    IN   BOOLEAN := TRUE
   );
END sf_timer;
/


CREATE OR REPLACE PUBLIC SYNONYM SF_TIMER FOR ADR.SF_TIMER;
DROP PACKAGE ADR.CCN_SRV_LOAD_PKG;

CREATE OR REPLACE PACKAGE ADR.CCN_SRV_LOAD_PKG
AS

  -- ******************************************************
  -- Purpose: This package is to mainly use for various ADR maintenance tasks
  --
  -- Version  Date       Who         Description
  -- ======= ========== ============ =======================================

  -- 1.0    05/30/2017  Richard Do   This package is to load data into ccn_service_log via pipe row pipelined
  --                                 Staging tables:
  --                                    CCN_PERSON_SELECTED_STG'
  --                                    CCN_ADDRESS_STG
  --                                    CCN_ADDRESS_H_STG
  --                                    CCN_PREFERED_FACILITY_H_STG'
  --                                    CCN_EMAIL_STG
  --                                    CCN_GEOCODE_TRANSMIT_STG'
  --                                    CCN_PHONE_STG
  --                                    CCN_DATALOAD_LOG_STG
  --                                    CCN_SERVICE_LOG_LOAD_VW
  --                                Main SP: PROCESS_CCN_SERVICE_LOG_MAIN
  --				    Stats Log table: CCN_DATALOAD_LOG_STG

   CC_MODULE_NAME  CONSTANT VARCHAR2(40) := 'CCN_SRV_LOAD_PKG';
   gc_sp_name           VARCHAR2(120);
   gc_action_name       VARCHAR2(500);
   gc_cnt               NUMBER;

   gc_bulk_limit           NUMBER DEFAULT 10000;
   gc_parallel_dop          PLS_INTEGER DEFAULT 10000;

   TYPE CCN_SRVLOG_REC IS RECORD (
       person_id            ccn_service_log.person_id%TYPE,
       record_modified_date ccn_service_log.record_modified_date%TYPE
     );

   TYPE CCN_SRVLOG_TABLE IS TABLE OF CCN_SRVLOG_REC INDEX BY BINARY_INTEGER;
   CCN_SRVLOG_TAB CCN_SRVLOG_TABLE;

   TYPE ccn_staging_rowcount_rec IS RECORD
   (
      rowcount_person   NUMBER,
      rowcount_addr     NUMBER,
      rowcount_addr_h   NUMBER,
      rowcount_prefac   NUMBER,
      rowcount_email    NUMBER,
      rowcount_phone    NUMBER,
      rowcount_geotrans NUMBER
   );

     ccn_stage_rowcount_rec   ccn_staging_rowcount_rec;

   TYPE CCNSERVICELOG_TGT_REC IS RECORD(
        SERVICE_LOG_STAT_ID      NUMBER(20),
        PERSON_ID                NUMBER(20),
        FIRST_NAME               VARCHAR2(35),
        LAST_NAME                VARCHAR2(35),
        MID_NAME                 VARCHAR2(25),
        SUFFIX                   VARCHAR2(10),
        DATE_OF_BIRTH_TXT        VARCHAR2(30),
        DATE_OF_DEATH            VARCHAR2(20),
        BIRTH_SEX                VARCHAR2(1),
        MAILING_ADDRESS_H_ID     NUMBER(20) ,
        EMAIL                    VARCHAR2(128),
        VCELIGIBILITY_H_ID       NUMBER(20),
        HPHONE_NUM               VARCHAR2(50),
        CPHONE_NUM               VARCHAR2(50),
        TPHONE_NUM               VARCHAR2(50),
        VISN_GEO                 VARCHAR2(10),
        RESI_ADDRESS_H_ID        NUMBER(20),
        PREFERRED_FACILITY_H_ID  NUMBER(20),
        GEOCODE_STATION_H_ID     NUMBER(20),
        ADDR_RECORD_MODIFIED_DATE DATE,
        VCELIGBTY_RECORD_MODIFIED_DATE    DATE,
        SVL_RECORD_MODIFIED_DATE    DATE
   );

   TYPE  CCNSERVICELOG_TGT_TAB IS TABLE OF CCNSERVICELOG_TGT_REC;
   TYPE  CCNSERVLOG_SRC_REFCUR IS REF CURSOR RETURN ADR.CCN_SERVICE_LOG_LOAD_VW%ROWTYPE;

   FUNCTION CCNSERVICELOG_PTF (dataset_refcur CCNSERVLOG_SRC_REFCUR)
    RETURN CCNSERVICELOG_TGT_TAB
        PARALLEL_ENABLE(PARTITION dataset_refcur BY HASH (PERSON_ID)) PIPELINED;

   PROCEDURE SET_BULK_LOAD_LIMIT (p_bulk_load_lim IN NUMBER);
   PROCEDURE SET_DOP (p_parallel_dop IN NUMBER);
   PROCEDURE INITIALIZE_COLLECTION;
   PROCEDURE POSTCHECK_PROC;
   PROCEDURE PRECHECK_PROC(p_ready_run_status OUT BOOLEAN);
   PROCEDURE ALTER_SESSION_SETTINGS (p_dop NUMBER);
   PROCEDURE PURGE_STG_TABLE;
   PROCEDURE LOAD_SELECTED_PERSON_STG;
   PROCEDURE LOAD_ADDR_STG;
   PROCEDURE LOAD_ADDR_H_STG;
   PROCEDURE LOAD_PREFERED_FACILITY_H_STG;
   PROCEDURE LOAD_EMAIL_STG;
   PROCEDURE LOAD_GEOCODE_TRANSMIT_STG;
   PROCEDURE LOAD_PHONE_STG;
   PROCEDURE LOAD_SRV_LOG_DATA (p_total_count OUT NUMBER);
   PROCEDURE UPDATE_SRV_LOG_DATA (p_total_count OUT NUMBER);
   -- Main program
   PROCEDURE PROCESS_CCN_SERVICE_LOG_MAIN;

END CCN_SRV_LOAD_PKG;
/


CREATE OR REPLACE PUBLIC SYNONYM CCN_SRV_LOAD_PKG FOR ADR.CCN_SRV_LOAD_PKG;
